package com.maila.biz.center.api.enums;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * 麦啦皮肤市场皮肤类型
 * ClassName:MailaSkinTypeEnum
 * Date     : 2017年03月01日 16:36:41
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
public enum MailaSkinTypeEnum {

    MAILA_INDEX(1, "麦啦首页"),
    MAILA_SPECIAL(2, "麦啦专场"),
    DUIBA_INDEX(3, "兑吧首页"),
    DUIBA_SPECIAL(4, "兑吧专场"),
    ROB_INDEX(5,"抢购首页皮肤"),
    ROB_DETAIL(6,"抢购详情页皮肤"),
    SEARCH_DETAIL(7,"搜索详情页皮肤"),
    WX_GOODS_DETAIL(8,"微信商品详情页"),
    GUESS_LIKE_INDEX(9,"猜你喜欢详情页"),
    ROB_GOODS_DETAIL(10,"今日必抢商品详情页"),
    JQG_APP_INDEX(11,"聚钱购app皮肤");

    private int id;
    private String name;

    MailaSkinTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    /**
     * 根据id 查询
     *
     * @param id
     * @return
     */
    public static MailaSkinTypeEnum findTypeById(int id) {
        for (MailaSkinTypeEnum skinTypeEnum : MailaSkinTypeEnum.values()) {
            if (skinTypeEnum.getId() == id) {
                return skinTypeEnum;
            }
        }
        return null;
    }

    /**
     * 存入map
     *
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
