package com.maila.biz.center.api.param;

import java.io.Serializable;
import java.util.Date;

/**
 * 麦啦管理员后台商品库筛选参数类
 * @Author zhanghuifeng
 * @Date 15:31 2017/1/20
 */
public class MailaGoodsQryParam implements Serializable {
	private static final long serialVersionUID = -6378493698695157494L;

	/**
	 * 管理后台显示商品名称
	 */
	private String name4admin;

	/**
	 * 手机端显示商品名称
	 */
	private String title;

	/**
	 * 商品类型:淘宝itemId,url @See MailaGoodsType
	 */
	private Integer goodsType;

	/**
	 * 0 表示第三方、大淘客 1表示自主招商
	 */
	private Integer merchantsType;

	/**
	 * 商品状态:待上架，已上架，已下架 @See GoodsSpecialStatus
	 */
	private Integer goodsStatus;

	/**
	 * 上架开始时间
	 */
	private Date autoEnableStartTime;

	/**
	 * 上架结束时间
	 */
	private Date autoEnableEndTime;

	/**
	 * 下架开始时间
	 */
	private Date autoDisableStartTime;

	/**
	 * 下架结束时间
	 */
	private Date autoDisableEndTime;

	/**
	 *  偏移量
	 */
	private Integer offset;

	/**
	 * 每页条数
	 */
	private Integer pageSize;

	/**
	 * 审核人
	 */
	private String auditor;

	/**
	 * 类目
	 */
	private Integer category;

	/**
	 * 佣金比例
	 */
	private Integer commissionRate;

	/**
	 * 商品ID
	 */
	private Long goodsId;

	/**
	 * 淘宝商品ID
	 */
	private Long itemId;

	/**
	 * 操作人
	 */
	private String operator;

	/**
	 * 起始价格
	 */
	private Integer autoStartPrice;

	/**
	 * 结束价格
	 */
	private Integer autoEndPrice;

	/**
	 * 销量
	 */
	private Integer salesVolume;

	/**
	 * 优惠券面值
	 */
	private Integer couponValue;

	public String getName4admin() {
		return name4admin;
	}

	public void setName4admin(String name4admin) {
		this.name4admin = name4admin;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getGoodsType() {
		return goodsType;
	}

	public void setGoodsType(Integer goodsType) {
		this.goodsType = goodsType;
	}

	public Integer getGoodsStatus() {
		return goodsStatus;
	}

	public void setGoodsStatus(Integer goodsStatus) {
		this.goodsStatus = goodsStatus;
	}

	public Date getAutoEnableStartTime() {
		return autoEnableStartTime;
	}

	public void setAutoEnableStartTime(Date autoEnableStartTime) {
		this.autoEnableStartTime = autoEnableStartTime;
	}

	public Date getAutoEnableEndTime() {
		return autoEnableEndTime;
	}

	public void setAutoEnableEndTime(Date autoEnableEndTime) {
		this.autoEnableEndTime = autoEnableEndTime;
	}

	public Date getAutoDisableStartTime() {
		return autoDisableStartTime;
	}

	public void setAutoDisableStartTime(Date autoDisableStartTime) {
		this.autoDisableStartTime = autoDisableStartTime;
	}

	public Date getAutoDisableEndTime() {
		return autoDisableEndTime;
	}

	public void setAutoDisableEndTime(Date autoDisableEndTime) {
		this.autoDisableEndTime = autoDisableEndTime;
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public String getAuditor() {
		return auditor;
	}

	public void setAuditor(String auditor) {
		this.auditor = auditor;
	}

	public Integer getMerchantsType() {
		return merchantsType;
	}

	public void setMerchantsType(Integer merchantsType) {
		this.merchantsType = merchantsType;
	}

	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	public Integer getCommissionRate() {
		return commissionRate;
	}

	public void setCommissionRate(Integer commissionRate) {
		this.commissionRate = commissionRate;
	}

	public Long getGoodsId() {
		return goodsId;
	}

	public void setGoodsId(Long goodsId) {
		this.goodsId = goodsId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public Integer getAutoStartPrice() {
		return autoStartPrice;
	}

	public void setAutoStartPrice(Integer autoStartPrice) {
		this.autoStartPrice = autoStartPrice;
	}

	public Integer getAutoEndPrice() {
		return autoEndPrice;
	}

	public void setAutoEndPrice(Integer autoEndPrice) {
		this.autoEndPrice = autoEndPrice;
	}

	public Integer getSalesVolume() {
		return salesVolume;
	}

	public void setSalesVolume(Integer salesVolume) {
		this.salesVolume = salesVolume;
	}

	public Integer getCouponValue() {
		return couponValue;
	}

	public void setCouponValue(Integer couponValue) {
		this.couponValue = couponValue;
	}
}
