package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.MailaAdminDto;

import java.util.List;

/**
 * 麦啦后台管理员服务类
 * <p>
 * ClassName:RemoteMailaAdminBackendService
 * Date     : 2016年11月16日 19:07:45
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaAdminBackendService {

    /**
     * 添加管理员
     *
     * @param mailaAdminDto
     * @return
     */
    DubboResult<BusinessMsgDto> addManager(MailaAdminDto mailaAdminDto);

    /**
     * 更新管理员
     *
     * @param mailaAdminDto
     * @return
     */
    DubboResult<BusinessMsgDto> updateManager(MailaAdminDto mailaAdminDto);

    /**
     * 删除管理员
     *
     * @param managerId
     * @return
     */
    DubboResult<Integer> delManager(Long managerId);

	/**
     * 查询管理员
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<MailaAdminDto>> findManager(Integer offset, Integer pageSize);

    /**
     * 查询管理员总数
     *
     * @return
     */
    DubboResult<Long> countForFindManager();

    /**
     * 根据id查询
     *
     * @param managerId
     * @return
     */
    DubboResult<MailaAdminDto> findById(Long managerId);

    /**
     * 管理员登陆
     *
     * @param account
     * @param password
     * @return
     */
    DubboResult<BusinessMsgDto> login(String account, String password);

    /**
     * 根据账号获取管理员
     *
     * @param account
     * @return
     */
    DubboResult<MailaAdminDto> findByAccount(String account);

}
