package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.MailaAppSkinDto;

/**
 * 功能描述:供手机端获取皮肤service
 *
 * @author sunchangji
 * @date 2016/11/16
 */
@AdvancedFeignClient
public interface RemoteMailaAppSkinService {
	/**
	 * 根据应用id获取首页对应皮肤对象
	 *
	 * @param appId 应用id
	 * @return
	 */
	DubboResult<MailaAppSkinDto> getAppIndexSkinByAppId(Long appId);

	/**
	 * 根据应用id获取专场对应皮肤对象
	 *
	 * @param appId 应用id
	 * @return
	 */
	DubboResult<MailaAppSkinDto> getAppSpecialSkinByAppId(Long appId);
}
