package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.BusinessMsgDto;
import com.maila.biz.center.api.dto.MailaDeveloperDto;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * 麦啦管理员后台开发者服务类
 * <p>
 * ClassName:RemoteMailaDeveloperBackendService
 * Date     : 2016年11月14日 10:54:11
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaDeveloperBackendService {

    /**
     * 分页查询麦啦开发者
     *
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<MailaDeveloperDto>> findAll(Integer offset, Integer pageSize);

    /**
     * 查询麦啦开发者，无分页
     *
     * @return
     */
    @RequestMapping("findAll1")
    DubboResult<List<MailaDeveloperDto>> findAll();


    /**
     * 分页查询麦啦开发者总数
     *
     * @return
     */
    DubboResult<Long> countForFindAll();

    /**
     * 注册麦啦开发者
     *
     * @param mailaDeveloperDto
     * @return
     */
    DubboResult<BusinessMsgDto> register(MailaDeveloperDto mailaDeveloperDto);

    /**
     * 开发者账号是否注册过
     *
     * @param account
     * @return
     */
    DubboResult<Boolean> isAccountExists(String account);

	/**
     * 根据开发者主键查询开发者信息
     *
     * @param id 开发者主键id
     *
     * @return DubboResult<MailaDeveloperDto>
     */
    DubboResult<MailaDeveloperDto> findById(Long id);

	/**
     * 更新开发者信息
     *
     * @param mailaDeveloperDto 开发者信息对象
     *
     * @return Boolean(true更新成功,false更新失败)
     */
    DubboResult<BusinessMsgDto> updateMailaDeveloper(MailaDeveloperDto mailaDeveloperDto);

    /**
     * 根据兑吧开发者id查询兑吧类型记录是否已经存在
     *
     * @param duibaDevId 兑吧开发者id
     * @return
     */
    DubboResult<Boolean> isExistDuibaDevId(Long duibaDevId);

    /**
     * 根据 account 查开发者账户
     *
     * @param accout
     * @return
     */
    DubboResult<MailaDeveloperDto> findByAccount(String accout);

    /**
     * 更新开发者后台权限
     * @param id               开发者id
     * @param permissionSwitch 权限 @see MailaDeveloperPermissionEnum
     * @return boolean
     */
    Boolean updatePermissionById(Long id, Long permissionSwitch);
}
