package com.maila.biz.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila.biz.center.api.dto.CouponGoodsThresholdDto;
import com.maila.biz.center.api.dto.MailaExportGoodsQryDto;
import com.maila.biz.center.api.dto.MailaGoodsDto;
import com.maila.biz.center.api.param.MailaGoodsQryParam;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 麦啦商品服务类
 * <p>
 * ClassName:RemoteMailaGoodsBackendService
 * Date     : 2016年11月04日 13:47:38
 *
 * @author huangsenfa
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteMailaGoodsBackendService {

    /**
     * 管理员后台根据名称或标题模糊查询商品 （分页查询）
     *
     * @param mailaGoodsQryParam
     * @return 商品列表集
     * @author huangsenfa
     * @date 2016年11月04日 09:48:01
     */
    DubboResult<List<MailaGoodsDto>> findByNameOrTitle(MailaGoodsQryParam mailaGoodsQryParam);

    /**
     * 管理员后台根据名称模糊查询商品总数量 （分页查询）
     *
     * @param mailaGoodsQryParam
     * @return
     */
    DubboResult<Long> countForFindByNameOrTitle(MailaGoodsQryParam mailaGoodsQryParam);

    /**
     * 管理员后台添加麦啦商品
     *
     * @param mailaGoodsDto 管理员后台商品实体
     * @return
     */
    DubboResult<Integer> addMailaGoods(MailaGoodsDto mailaGoodsDto);

    /**
     * 管理员后台更新麦啦商品
     *
     * @param mailaGoodsDto 管理员后台商品实体
     * @return
     */
    DubboResult<Integer> updateMailaGoods(MailaGoodsDto mailaGoodsDto);

    /**
     * 管理员后台更新商品状态
     *
     * @param goodsId      商品id
     * @param targetStatus 商品目标状态
     * @return
     */
    DubboResult<Integer> updateGoodsStatus(Long goodsId, Integer targetStatus);

    /**
     * 根据商品id获取商品
     *
     * @param goodsId 商品id
     * @return
     */
    DubboResult<MailaGoodsDto> findByGoodsId(Long goodsId);

    /**
     * 根据名称或id查询所有商品
     *
     * @param value 名称或id
     * @return
     */
    DubboResult<List<MailaGoodsDto>> findGoodsByNameOrId(String value);

    /**
     * 单个商品添加至多专场
     *
     * @param goodsId    商品id
     * @param specialIds 专场id集
     * @return
     */
    DubboResult<Integer> pushSingleGoodsToSpecials(Long goodsId, List<Long> specialIds);

	/**
	 * 管理员后台手动失效商品
     *
     * @param goodsId   商品goodsId
     * @param reasonMsg 手动失效原因
     * @return
     */
    DubboResult<Integer> handFailureGoods(Long goodsId,String reasonMsg);

	/**
     * 管理员后台单个商品添加多个应用
     * @param goodsId 商品goodsId
     * @param appIds  应用id集合
     * @return
     */
    DubboResult<Boolean> pushSingGoodsToApps(Long goodsId, List<Long> appIds);

	/**
     *
     * @param goodsIds
     * @return
     */
    DubboResult<List<MailaGoodsDto>> selectMailaGoodsByGoodsIds(List<Long> goodsIds);

	/**
     *
     * @param dto
     * @return
     */
    DubboResult<List<MailaGoodsDto>> findExportGoods(MailaExportGoodsQryDto dto);

    /**
     *
     * @param createDate
     * @param autoStartDate
     * @return
     */
    DubboResult<MailaExportGoodsQryDto> findGoodsRowAndMax(Date createDate, Date autoStartDate);

    /**
     * 在商品库中是否存在有效期冲突的商品
     * @param itemId
     * @param autoStartTime
     * @param autoEndTime
     * @return
     */
    DubboResult<Boolean> isExistInGoods(Long itemId, Date autoStartTime, Date autoEndTime);

	/**
	 * 将商品库中所有待生效和生效中的商品批量
	 * 插入单个应用商品虚拟库和全部类型的tab中
	 * @param appId  应用id
	 * @return
	 */
	DubboResult<Boolean> pushAllGoodsToSingleApp(Long appId);

    /**
     * 通过淘宝itemid 查询相应的GoodIds
     *
     * @param itemIds the item ids
     * @return the dubbo result
     */
    DubboResult<List<MailaGoodsDto>> selectGoodsIdsByInItemIds(Set<Long> itemIds);

	/**
	 * 获取优惠券商品在线总数和优惠券预警阈值及失效商品数
	 * @return CouponGoodsThresholdDto
	 */
	DubboResult<CouponGoodsThresholdDto> findThresholdInfo();

	/**
	 * 设置优惠券失效每天下线商品总数预警阈值
	 * @param threshold 预警阈值设置
	 * @return boolean
	 */
	DubboResult<Boolean> setThresholdInfo(int threshold);

	/**
	 * 多个商品添加至多专场
	 *
	 * @param goodsIds    商品id集合
	 * @param specialIds 专场id集
	 * @return Boolean
	 */
	DubboResult<Boolean> batchInToSpecials(List<Long> goodsIds, List<Long> specialIds);

	/**
	 * 修复淘宝一级和二级类目数据
	 * @return
	 */
	Boolean repairCatName();
}
