package com.maila88.modules.activity.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.activity.dto.Maila88ModuleDto;
import com.maila88.modules.activity.enums.Maila88ModuleTypeEnum;

import java.util.List;

/**
 * 组件后台服务
 *
 * Created by peanut.huang on 2017/9/7.
 */
@AdvancedFeignClient
public interface RemoteMaila88ModuleBackendService {

    /**
     * 组件分页列表
     *
     * @param name        组件名称
     * @param moduleType  组件类型 {@link Maila88ModuleTypeEnum#id}
     * @param pageNum
     * @param pageSize
     * @return
     */
    Maila88PageDto<Maila88ModuleDto> pagesList(String name, Integer moduleType, Integer pageNum, Integer pageSize);

    /**
     * 添加组件
     *
     * @param moduleDto
     * @return
     */
    Boolean addModule(Maila88ModuleDto moduleDto);

    /**
     * 更新组件
     *
     * @param moduleDto
     * @return
     */
    Boolean updateModule(Maila88ModuleDto moduleDto);

    /**
     * 根据组件id查询
     *
     * @param moduleId
     * @return
     */
    Maila88ModuleDto findById(Long  moduleId);

    /**
     * 根据组件id集查询
     *
     * @param moduleIds
     * @return
     */
    List<Maila88ModuleDto> findByIds(List<Long> moduleIds);
}
