package com.maila88.modules.app.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.app.dto.Maila88SimpleAppDto;

import java.util.List;

/**
 * Created by sunchangji on 2017/5/8.
 */
@AdvancedFeignClient
public interface RemoteNewMaila88AppService {

    /**
     * 根据开发者id查询开发者下所有简单信息应用
     *
     * @param developId 开发者id
     * @return DubboResult<List<Maila88SimpleAppDto>>
     */
    DubboResult<List<Maila88SimpleAppDto>> findSimpleAppByDevId(Long developId);

    /**
     * 根据开发者id查询开发者下所有开启的应用简单信息
     *
     * @param developId 开发者id
     * @return List<Maila88SimpleAppDto>
     */
    List<Maila88SimpleAppDto> findSimpleOpenedApp(Long developId);
}
