package com.maila88.modules.autosort.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.common.dto.Maila88SelectDto;
import com.maila88.modules.autosort.dto.Maila88AppSortStrategyDto;
import com.maila88.modules.autosort.dto.Maila88AppStrategyAndTimeDto;
import com.maila88.modules.autosort.dto.Maila88AppTimeTriggerDto;
import com.maila88.modules.autosort.param.AppSortStrategyQryBean;

import java.util.List;

/**
 * Created by sunchangji on 2017/8/2.
 */
@AdvancedFeignClient
public interface Maila88AppSortAndTimeBackendService {

    /**
     * 分页查询应用排序策略
     *
     * @param qryBean
     * @return
     */
    DubboResult<Maila88PageDto<Maila88AppStrategyAndTimeDto>> findPageAppSortStrategy(AppSortStrategyQryBean qryBean);

    /**
     * 添加应用策略
     * @param sortStrategyDto
     * @return
     */
    DubboResult<Boolean> insertAppSortStrategy(Maila88AppStrategyAndTimeDto sortStrategyDto);

    /**
     * 根据应用id和名称查询应用id和名称，并排除掉已经加过策略的appId
     *
     * @param appNameOrId
     * @return
     */
    DubboResult<List<Maila88SelectDto>> findMailaAppIdAndName(String appNameOrId);

    /**
     * 删除应用自动化排序策略
     * @param appId  应用id
     * @return
     */
     DubboResult<Boolean> deleteSortStrategyByAppId(Long appId);

    /**
     * 根据应用id查询排序策略
     * @param appId
     * @return
     */
     DubboResult<Maila88AppSortStrategyDto> findStrategyByAppId(Long appId);

    /**
     * 根据appId查询时间
     * @param appId
     * @return
     */
     DubboResult<List<Maila88AppTimeTriggerDto>> findTimeTriggerByAppId(Long appId);

    /**
     * 根据时间id删除触发时间
     * @param timeTriggerId
     * @return
     */
    DubboResult<Boolean> deleteTimeTriggerById(Long timeTriggerId);

    /**
     * 新增timeTrigger
     * @param triggerDto
     * @return
     */
    DubboResult<Boolean> insertTimeTrigger(Maila88AppTimeTriggerDto triggerDto);

    /**
     * 切换应用策略开关状态
     * @param appId
     * @param switches
     * @return
     */
    DubboResult<Boolean> changeStrategyStatus(Long appId,boolean switches);

    /**
     * 更新排序因子
     *
     * @param sortFactor 排序因子
     * @param id 主键
     * @return
     */
    DubboResult<Boolean> updateSortFactorById(String sortFactor, Long id);

}
