package com.maila88.modules.banner.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila.biz.center.api.dto.MailaBannerDto;
import com.maila88.modules.banner.dto.Maila88BannerBackendDto;

import java.util.List;

/**
 * 功能描述:
 *
 * @author sunchangji
 * @date 2016/11/7
 */
@AdvancedFeignClient
public interface RemoteMaila88BannerBackendService {

    /**
     * 根据分类id查询banner的详细信息，
     * 包括相关联的商品和专场的信息
     *
     * @param appId 应用id
     * @return
     */
    DubboResult<List<Maila88BannerBackendDto>> selectDetailByAppId(Long appId);

    /**
     * 新增Banner
     *
     * @param mailaBannerDto
     * @return
     */
    DubboResult<Long> insertMailaBanner(MailaBannerDto mailaBannerDto);

    /**
     * 更新Banner
     *
     * @param mailaBannerDto
     * @return
     */
    DubboResult<Boolean> updateMailaBanner(MailaBannerDto mailaBannerDto);

    /**
     * 根据所在位置更新对应的排序值
     *
     * @param bannerIds banner的id集合
     * @return
     */
    DubboResult<Boolean> batchUpdatePayload(List<Long> bannerIds);

    /**
     * 更新Banner状态
     *
     * @param enable 1:启用,0:禁用
     * @param id     bannerId
     * @return
     */
    DubboResult<Boolean> updateBannerEnable(int enable, Long id);

    /**
     * 根据bannerId逻辑删除banner
     *
     * @param id bannerId
     * @return DubboResult<Boolean>
     */
    DubboResult<Boolean> deleteById(Long id);
}
