package com.maila88.modules.blacklist.enums;

import java.util.Arrays;

/**
 * 应用黑名单内容类型枚举
 *
 * Created by peanut.huang on 2017/8/21.
 */
public enum Maila88AppBlacklistTypeEnum {

    GOODS(1,"商品"),

    TAGS(2,"标签");

    private int id;

    private String desc;

    Maila88AppBlacklistTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    public static Maila88AppBlacklistTypeEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }
        return Arrays.asList(Maila88AppBlacklistTypeEnum.values()).stream().filter(e-> e.getId() == id).findFirst().orElse(null);
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }
}

