package com.maila88.modules.floor.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Maps;

import java.util.HashMap;
import java.util.Map;

/**
 * 楼层类型枚举
 *
 * Created by peanuthuang on 2017/5/19.
 */
public enum Maila88FloorTypeEnum {

    BANNER(1,"banner","轮播"),
    ICON(2,"icon","图标"),
    TAB(3,"tab","分类TAB"),
    GOODS(4,"goods","商品区"),
    SHOWCASE(5,"showcase","橱窗"),
    BOTTOM_TAB(6,"bottomTab","底部TAB"),
    FLOATING(7,"floating","浮标"),
    POP(8,"pop","弹层"),
    NOTICE(9,"notice","公告"),
    DEFINED_IMG(10,"definedImg","自定义图片"),
    DEFINED_AD(11,"definedAd","自定义广告"),
    BELT(12,"belt","腰封"),
    PURCHASE(13,"pruchase","抢购"),
    SEARCH(14,"search","搜索"),
    DEFINED(15,"defined","自定义楼层");

    /**
     * id
     */
    private int id;

    /**
     * 字段
     */
    private String field;

    /**
     * 名称
     */
    private String name;

    Maila88FloorTypeEnum(int id, String field,String name){
        this.id = id;
        this.field = field;
        this.name = name;
    }

    /**
     * 根据id获取类型
     *
     * @param id
     * @return
     */
    public static Maila88FloorTypeEnum findById(Integer id){
        if(id == null || id <= 0){
            return null;
        }
        Maila88FloorTypeEnum [] floorTypeEnums = Maila88FloorTypeEnum.values();
        for(Maila88FloorTypeEnum floorType:floorTypeEnums){
            if(floorType.getId() == id){
                return floorType;
            }
        }
        return null;
    }

    /**
     * 转换为json
     * @return
     */
    @JsonValue
    public Map<String, Object> trans2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }

    /**
     * 获取全部楼层类型
     * @return
     */
    public static Map<Integer, String> getAllType() {
        Map<Integer, String> map = Maps.newHashMap();
        for (Maila88FloorTypeEnum value : Maila88FloorTypeEnum.values()) {
            map.put(value.getId(), value.getName());
        }
        return map;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getField() {
        return field;
    }
}
