package com.maila88.modules.goods.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * 麦啦商品状态
 */
public enum Maila88GoodsStatusEnum {

    READY(0, "待生效"),
    ON_SALE(1, "已生效"),
    OFF_SALE(-1, "已失效"),
    INVALID(-2, "手动失效"),
    AUTO_INVALID(-3,"系统下架");

    private int    value;
    private String name;

    Maila88GoodsStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static String getByValue(final int value) {
        Collection<Maila88GoodsStatusEnum> result = Collections2.filter(Arrays.asList(Maila88GoodsStatusEnum.values()), gs -> gs.getValue() == value);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }
}
