package com.maila88.modules.goods.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.goods.dto.Maila88AppGoodsDto;
import com.maila88.modules.goods.dto.Maila88AppSimpleGoodsDto;

/**
 * Created by gyf .
 * 2017/7/12 .
 */
@AdvancedFeignClient
public interface RemoteMaila88AppGoodsService {

    /**
     * 获取appGoods 组合的dto
     *
     * @param appId
     * @param goodsId
     * @return
     */
    DubboResult<Maila88AppGoodsDto> findUnionGoods(Long appId, Long goodsId);

    /**
     * 获取应用商品简单商品信息,个性化覆盖属性
     *
     * @param appId   麦啦应用id
     * @param goodsId 麦啦商品id
     * @return DubboResult<Maila88AppSimpleGoodsDto>
     */
    DubboResult<Maila88AppSimpleGoodsDto> findUnionAppGoodsContent(Long appId, Long goodsId);

}
