package com.maila88.modules.goods.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.goods.dto.Maila88GoodsDto;
import com.maila88.modules.goods.dto.Maila88GoodsSelectDto;
import com.maila88.modules.goods.param.Maila88GoodsQryParam;

import java.util.List;

/**
 * Created by gyf .
 * 2017/4/26 .
 */
@AdvancedFeignClient
public interface RemoteMaila88GoodsBackendService {

    /**
     * 查询商品只包含商品id和商品名称数据
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88GoodsSelectDto>> findGoodsIdAndName(int offset, int pageSize);

    /**
     * 根据 商品名称或商品id 查询待生效或已生效的商品
     * @param queryParam
     * @return
     */
    DubboResult<List<Maila88GoodsSelectDto>> findByGoodsIdOrName(String queryParam);

    /**
     * 单个删除黑名单
     * @param appId
     * @param goodsId
     * @return
     */
    DubboResult<Boolean> deleteBlacklist(Long appId, Long goodsId);

    /**
     * 批量删除黑名单
     * @param appId
     * @param goodsIds
     * @return
     */
    DubboResult<Boolean> batchDeleteBlacklist(Long appId, List<Long> goodsIds);

    /**
     * 根据淘宝itemId集获取麦啦商品集
     *
     * @param itemIds    淘宝itemId集
     * @return           麦啦商品集
     */
    DubboResult<List<Maila88GoodsDto>> findByItemIds(List<Long> itemIds);

    /**
     * 根据 商品名称或商品id 查询待生效或已生效的商品
     * @param queryParam
     * @return
     */
    DubboResult<List<Maila88GoodsDto>> findByGoodsIdOrName2(String queryParam);

    /**
     * 通过商品id查找
     * @param goodsList
     * @return
     */
    DubboResult<List<Maila88GoodsDto>> findByGoodsIds(List<Long> goodsList);

    /**
     * 插入操作
     * @param goods
     * @return
     */
    DubboResult<Boolean> insert4Import(Maila88GoodsDto goods);

    /**
     * 根据条件分页查询商品主库有效的商品（生效和待生效）
     * @param qryParam 查询条件
     * @return 集合
     */
    Maila88PageDto<Maila88GoodsDto> findAbleGoods4PageByCondition(Maila88GoodsQryParam qryParam);
}
