package com.maila88.modules.merchants.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 商家商品审核
 * Author: zhanghuifeng
 * Date:   15:20 2017/6/6
 */
public class MailaMerchantsGoodsAuditDto implements Serializable {
	private static final long serialVersionUID = 6445093003610317964L;

	/**
	 * 主键
	 **/
	private Long id;

	/**
	 * 审核状态(1:待提交,2:待审核,3:审核不通过,4:审核通过,5:活动中,6:已失效,7:已结束)
	 **/
	private Integer goodsStatus;

	/**
	 * 审核不通过原因或下架原因
	 **/
	private String reasonMsg;

	/**
	 * 麦啦排期开始时间(对应麦啦商品库的autoStartTime)
	 **/
	private Date scheduleStartTime;

	/**
	 * 麦啦排期开始时间(对应麦啦商品库的autoEndTime)
	 **/
	private Date scheduleEndTime;

	/**
	 * 审核人ID
	 */
	private String auditor;

	/**
	 * 操作人
	 */
	private String operator;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getGoodsStatus() {
		return goodsStatus;
	}

	public void setGoodsStatus(Integer goodsStatus) {
		this.goodsStatus = goodsStatus;
	}

	public String getReasonMsg() {
		return reasonMsg;
	}

	public void setReasonMsg(String reasonMsg) {
		this.reasonMsg = reasonMsg;
	}

	public Date getScheduleStartTime() {
		return scheduleStartTime;
	}

	public void setScheduleStartTime(Date scheduleStartTime) {
		this.scheduleStartTime = scheduleStartTime;
	}

	public Date getScheduleEndTime() {
		return scheduleEndTime;
	}

	public void setScheduleEndTime(Date scheduleEndTime) {
		this.scheduleEndTime = scheduleEndTime;
	}

	public String getAuditor() {
		return auditor;
	}

	public void setAuditor(String auditor) {
		this.auditor = auditor;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
}
