package com.maila88.modules.merchants.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;

import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.merchants.dto.Maila88AuditShopDto;
import com.maila88.modules.merchants.dto.Maila88AuditShopQueryDto;
import com.maila88.modules.merchants.dto.Maila88ShopDto;

/**
 * 管理员后台商家店铺
 * Author: zhanghuifeng
 * Date:   16:20 2017/4/24
 */
@AdvancedFeignClient
public interface RemoteMaila88ShopBackendService {

	/**
	 * 管理员后台通过条件查询商家店铺审核信息（分页）
	 *
	 * @param queryDto 参数对象
	 *
	 * @return Maila88PageDto<Maila88AuditShopDto>
	 */
	DubboResult<Maila88PageDto<Maila88AuditShopDto>> findShopsAuditByPage(Maila88AuditShopQueryDto queryDto);

	/**
	 * 管理员后台商家店铺管理查询（分页）
	 *
	 * @param shopType 店铺类型
	 * @param mainType 主营类目
	 * @param shopKeeper 掌柜
	 * @param auditor   审核人
	 * @param offset     偏移量
	 * @param pageSize   每页数量
	 * @return Maila88PageDto<Maila88ShopDto>
	 */
	DubboResult<Maila88PageDto<Maila88ShopDto>> findShopsByPage(Integer shopType, Integer mainType, String shopKeeper, String auditor, Integer offset, Integer pageSize);

	/**
	 * 管理员后台商家店铺审核
	 *
	 * @param id       店铺Id
	 * @param auditStatus  审核状态
	 * @param refuseReason 审核不通过原因
	 * @param auditor 审核人
	 * @return Boolean
	 */
	DubboResult<Boolean> auditingShop(Long id, Integer auditStatus, String refuseReason, String auditor);

	/**
	 * 管理员后台编辑店铺信息
	 *
	 * @param mailaShopsDto 店铺信息
	 * @return Boolean
	 */
	DubboResult<Boolean> updateShopInfo(Maila88ShopDto mailaShopsDto);

	/**
	 * 管理员后台冻结店铺
	 *
	 * @param shopId          店铺ID
	 * @param frozenStartTime 冻结开始时间
	 * @param frozenEndTime	  冻结结束时间
	 * @param auditor         审核人
	 * @return Boolean
	 */
	DubboResult<Boolean> saveShopFrozenInfo(Long shopId, Date frozenStartTime, Date frozenEndTime, String auditor);

	/**
	 * 根据店铺id查询店铺信息
	 * @param id 店铺id
	 * @return Maila88ShopDto
	 */
	DubboResult<Maila88ShopDto> findShopsById(Long id);
}
