package com.maila88.modules.odps.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.odps.dto.Maila88AutoReportDto;
import com.maila88.modules.odps.enums.Maila88AutoReportFileStatusEnum;
import com.maila88.modules.odps.enums.Maila88AutoReportTypeEnum;

import java.util.Date;
import java.util.List;

/**
 * 自动化报表后台服务
 *
 * Created by peanut.huang on 2017/7/14.
 */
@AdvancedFeignClient
public interface RemoteMaila88AutoReportBackendService {

    /**
     * 保存文件上传记录
     *
     * @param fileName   文件名称
     * @param fileUrl    文件cdn路径
     * @param fileType   文件类型 {@link Maila88AutoReportFileStatusEnum#id }
     * @param fileDate   文件隶属日期
     * @return
     */
    DubboResult<Boolean> saveFile(String fileName, String fileUrl, Integer fileType, Date fileDate);

    /**
     * 获取相应日期的报表数据列表
     *
     * @param currentDate   当前日期
     * @param reportType    报表类型 {@link Maila88AutoReportTypeEnum}
     * @return
     */
    DubboResult<List<Maila88AutoReportDto>> findReportList(Date currentDate, Integer reportType);
}
