package com.maila88.modules.odps.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.odps.dto.MailaDailyReportDto;
import com.maila88.modules.odps.dto.MailaReportChartDto;
import com.maila88.modules.odps.param.MailaDailyQueryParam;

import java.util.Date;
import java.util.List;

/**
 * 应用维度日报表数据
 * Created by sunchangji on 2017/5/3.
 */
@AdvancedFeignClient
public interface RemoteMailaDailyReportService {

    /**
     * 根据应用id查找昨日数据
     *
     * @param appId 应用id
     * @return DubboResult<MailaDailyReportDto>
     */
    DubboResult<MailaDailyReportDto> findYesterdayByAppId(Long appId);

    /**
     * 根据应用查询参数查询订单信息,不包含页面pv,uv相关的数据填充
     *
     * @param queryParam 查询条件参数对象
     * @return DubboResult<List<MailaDailyReportDto>>
     */
    DubboResult<List<MailaDailyReportDto>> findOrderDataByAppId(MailaDailyQueryParam queryParam);

    /**
     * 根据应用查询参数查询页面信息,不包含订单相关的数据填充
     *
     * @param queryParam 查询条件参数对象
     * @return DubboResult<List<MailaDailyReportDto>>
     */
    DubboResult<List<MailaDailyReportDto>> findPageDataByAppId(MailaDailyQueryParam queryParam);

    /**
     * 根据条件查询总记录数
     *
     * @param queryParam 查询条件参数对象
     * @return DubboResult<Integer>
     */
    DubboResult<Integer> findCount(MailaDailyQueryParam queryParam);

    /**
     * 查询30天某一个应用的折线图数据
     *
     * @param appId 应用id
     * @return DubboResult<List<MailaReportChartDto>>
     */
    DubboResult<List<MailaReportChartDto>> findChartByAppId(Long appId);

    /**
     * 物理删除回流数据表中指定appId某一段时间内数据
     * @param appId   麦啦appId
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return int
     */
    DubboResult<Boolean> deleteByDateStartAndEnd(Long appId, Date startDate, Date endDate);
}
