package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.modules.rob.dto.Maila88NewRobGoodsDetailDto;
import com.maila88.modules.rob.dto.Maila88NewRobGoodsDto;

import java.util.List;

/**
 * Created by johnkeng on 2017/7/11.
 */
@AdvancedFeignClient
public interface RemoteMaila88NewRobGoodsService {

    /**
     * 通过场次Id查询抢购商品
     * @param sceneId
     * @return
     */
    DubboResult<List<Maila88NewRobGoodsDto>> findBySceneIdOrderByPayload(Long sceneId);

    /**
     * 批量添加抢购商品
     * @return
     */
    DubboResult<Boolean> addRobGoods(List<Maila88NewRobGoodsDto> maila88NewRobGoodsDtoList);

    /**
     * 查询单个抢购商品
     * @param goodsId
     * @param sceneId
     * @return
     */
    DubboResult<Maila88NewRobGoodsDto> findByGoodsIdAndSceneId(Long goodsId, Long sceneId);

    /**
     * 更新抢购单个商品
     * @param newRobGoodsDto
     * @return
     */
    DubboResult<Boolean> updateRobGood(Maila88NewRobGoodsDto newRobGoodsDto);

    /**
     * 批量删除抢购商品
     * @param goodsIds
     * @param sceneId
     * @return
     */
    DubboResult<Boolean> deleteListByGoodsIdsAndSceneId(List<Long> goodsIds, Long sceneId);

    /**
     * 批量排序
     * @param goodsIds
     * @param sceneId
     * @return
     */
    DubboResult<Boolean> batchSort(List<Long> goodsIds, Long sceneId);

    /**
     * 手机端分页查询
     * @param sceneId
     * @param lastPayload
     * @param pageSize
     * @return
     */
    DubboResult<List<Maila88NewRobGoodsDetailDto>> findPageBySceneIdAndPayload(Long sceneId, Integer lastPayload, Integer pageSize);

    /**
     * 更新前抢购商品 Pv
     * @param goodsId
     * @param sceneId
     * @param goodsPv
     * @return
     */
    DubboResult<Boolean> updateGoodsPv(Long goodsId, Long sceneId, Long goodsPv, Long version);

    /**
     * 查询前抢购商品 Pv
     * @param goodsId
     * @param sceneId
     * @return
     */
    DubboResult<Long> findGoodsPv(Long goodsId, Long sceneId);
}
