package com.maila88.modules.rob.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

import com.maila88.modules.rob.dto.Maila88SceneDto;

/**
 * 手机端抢购场次
 * Author: zhanghuifeng
 * Date:   14:11 2017/5/4
 */
@AdvancedFeignClient
public interface RemoteMaila88SceneService {

	/**
	 * 根据应用ID查询场次
	 * @param appId 应用ID
	 * @return  List<Maila88SceneDto>
	 */
	DubboResult<List<Maila88SceneDto>> findSceneByAppId(Long appId);

	/**
	 * 根据场次ID查询场次信息
	 * @param id 场次id
	 * @return 场次信息
	 */
	DubboResult<Maila88SceneDto> findById(Long id);
}
