package com.maila88.modules.special.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 主专场下主库商品信息
 *
 * Created by sunchangji on 2017/6/29.
 */
public class Maila88SpecialGoodsDto implements Serializable {
    private static final long serialVersionUID = 1381039236218242918L;

    /**
     * 商品记录id
     */
    private Long id;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 管理后台显示商品名称
     */
    private String name4admin;

    /**
     * 手机端显示商品名称
     */
    private String title;

    /**商品副标题**/
    private String subTitle;

    /**淘宝商品id**/
    private Long itemId;

    /**优惠券详细信息链接地址**/
    private String couponUrl;

    /**
     * 商品类型:淘宝itemId,url @See MailaGoodsType
     */
    private Integer goodsType;

    /**
     * 商品内容，根据goodsType变化，itemId,URL @See MailaGoodsType
     */
    private String goodsContent;

    /**
     * 商品原价
     */
    private Integer originalPrice;

    /**
     * 商品优惠价
     */
    private Integer preferPrice;

    /**类目id(1女装,2男装,3鞋包,4内衣,5饰品,6运动,7美妆,8童装,
     * 9食品,10母婴,11百货,12汽车,13家电,14数码,15家装,16家纺,17其他)
     **/
    private Integer category;

    /**
     * 商品标签,例：包邮
     */
    private String tag;

    /**
     * 商品图地址
     */
    private String imgUrl;

    /**
     * 商品状态:待上架，已上架，已下架 @See GoodsSpecialStatus
     */
    private Integer goodsStatus;

    /**平台标识(-1:其他 0:淘宝,1:天猫)**/
    private Integer platformType;

    /**30天销量**/
    private Long volume;

    /**
     * 商品状态值:待上架，已上架，已下架 @See GoodsSpecialStatus
     */
    private String goodsStatusValue;

    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 自动启动时间
     */
    private Date autoStartTime;

    /**
     * 自动结束时间
     */
    private Date autoEndTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商品现价
     */
    private Integer finalPrice;

    /**
     * 创建人
     */
    private String auditor;

    /**
     * 佣金比例
     */
    private Integer commissionRate;

    /**
     *  0 表示第三方、大淘客 1表示自主招商
     */
    private Integer merchantsType;

    /**
     * 操作人
     */
    private String operator;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public String getName4admin() {
        return name4admin;
    }

    public void setName4admin(String name4admin) {
        this.name4admin = name4admin;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getCouponUrl() {
        return couponUrl;
    }

    public void setCouponUrl(String couponUrl) {
        this.couponUrl = couponUrl;
    }

    public Integer getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(Integer goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsContent() {
        return goodsContent;
    }

    public void setGoodsContent(String goodsContent) {
        this.goodsContent = goodsContent;
    }

    public Integer getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getPreferPrice() {
        return preferPrice;
    }

    public void setPreferPrice(Integer preferPrice) {
        this.preferPrice = preferPrice;
    }

    public Integer getCategory() {
        return category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getGoodsStatus() {
        return goodsStatus;
    }

    public void setGoodsStatus(Integer goodsStatus) {
        this.goodsStatus = goodsStatus;
    }

    public Integer getPlatformType() {
        return platformType;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public Long getVolume() {
        return volume;
    }

    public void setVolume(Long volume) {
        this.volume = volume;
    }

    public String getGoodsStatusValue() {
        return goodsStatusValue;
    }

    public void setGoodsStatusValue(String goodsStatusValue) {
        this.goodsStatusValue = goodsStatusValue;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getAutoStartTime() {
        return autoStartTime;
    }

    public void setAutoStartTime(Date autoStartTime) {
        this.autoStartTime = autoStartTime;
    }

    public Date getAutoEndTime() {
        return autoEndTime;
    }

    public void setAutoEndTime(Date autoEndTime) {
        this.autoEndTime = autoEndTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(Integer finalPrice) {
        this.finalPrice = finalPrice;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public Integer getCommissionRate() {
        return commissionRate;
    }

    public void setCommissionRate(Integer commissionRate) {
        this.commissionRate = commissionRate;
    }

    public Integer getMerchantsType() {
        return merchantsType;
    }

    public void setMerchantsType(Integer merchantsType) {
        this.merchantsType = merchantsType;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}
