package com.maila88.modules.special.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Collections2;
import com.maila.biz.center.api.enums.GoodsSpecialStatus;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * 专场状态
 *
 * Created by sunchangji on 2017/7/5.
 */
public enum Maila88SpecialStatusEnum {

    READY(0, "待生效"),
    ON_SALE(1, "已生效"),
    OFF_SALE(-1, "已失效"),
    INVALID(-2,"手动失效");

    private int id;
    private String name;

    Maila88SpecialStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }


    /**
     * 根据id获取名称
     *
     * @param id
     * @return
     */
    public static String getNameById(final int id) {
        Collection<GoodsSpecialStatus> result = Collections2.filter(Arrays.asList(GoodsSpecialStatus.values()), gs -> gs.getId() == id);
        return result.isEmpty() ? "" : result.iterator().next().getName();
    }

    /**
     * 存入map
     * @return
     */
    @JsonValue
    public Map<String, Object> transform2Map() {
        Map<String, Object> map = new HashMap<>();
        map.put("name", getName());
        map.put("id", getId());
        return map;
    }
}
