package com.maila88.modules.statistics.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.maila88.common.dto.Maila88PageDto;
import com.maila88.modules.statistics.dto.DeveloperAppsDaliyReportDto;

import java.util.Date;
import java.util.List;

/**
 * Created by sunchangji on 2017/7/25.
 */
@AdvancedFeignClient
public interface RemoteAppsDaliyReportBackendService {

    /**
     * 根据时间查询区间内数据
     *
     * @param developerId 开发者id
     * @param startDate   开始日期
     * @param endDate     结束日期
     * @param offset
     * @param pageSize
     * @return
     */
    DubboResult<Maila88PageDto<DeveloperAppsDaliyReportDto>> findByStatisticalDate(Long developerId, Date startDate, Date endDate, Integer offset, Integer pageSize);

    /**
     * 不分页查询日期区间内汇总数据
     * @param developerId
     * @param startDate
     * @param endDate
     * @return
     */
    DubboResult<List<DeveloperAppsDaliyReportDto>> findByStatisticalDateNoPage(Long developerId, Date startDate, Date endDate);
}
