package com.maila88.modules.user.enums;

import com.google.common.collect.Collections2;

import java.util.Arrays;
import java.util.Collection;

/**
 * Created by xianhongwei on 2017/8/16.
 */
public enum Maila88UserOsTypeEnum {

    ANDROID(1,"android"),

    IOS(2,"ios"),

    OTHER(3,"other");

    private int value;

    private String type;

    Maila88UserOsTypeEnum(int status, String name){
        this.value = status;
        this.type = name;
    }

    public int getValue() {
        return value;
    }

    public String getType() {
        return type;
    }


    public static String getNameByStatus(final int value) {
        Collection<Maila88UserOsTypeEnum> result = Collections2.filter(Arrays.asList(Maila88UserOsTypeEnum.values()), gs -> {
            assert gs != null;
            return gs.getValue() == value;
        });
        return result.isEmpty() ? "" : result.iterator().next().getType();
    }


}
