/*
 * Decompiled with CFR 0.152.
 */
package com.jsrcb.payment.client;

import com.jsrcb.payment.client.util.Assert;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;

public class ImportPFX {
    public static final String KEYSTORE_TYPE_PKCS12 = "pkcs12";
    public static final String KEYSTORE_TYPE_JKS = "jks";

    public static void main(String[] args) throws Exception {
        ImportPFX instance = new ImportPFX();
        if (args == null || args.length == 0) {
            instance.showUsage();
        }
        Properties properties = instance.loadProperties(args[0]);
        String pfxFile = properties.getProperty("jsrcb.pfx.file");
        String pfxPwd = properties.getProperty("jsrcb.pfx.password");
        String jksFile = properties.getProperty("jsrcb.jks.file");
        String jksPwd = properties.getProperty("jsrcb.jks.password");
        String keyAlias = properties.getProperty("jsrcb.merchant.key.alias");
        Assert.notNullorEmpty(pfxFile, "value of 'psbc.pfx.file' is null or empty.");
        Assert.notNull(pfxPwd, "value of 'psbc.pfx.password' is null.");
        Assert.notNullorEmpty(jksFile, "value of 'psbc.jks.file' is null or empty.");
        Assert.notNullorEmpty(jksPwd, "value of 'psbc.jks.password' is null or empty.");
        Assert.notNullorEmpty(keyAlias, "value of 'psbc.merchant.key.alias' is null or empty.");
        Security.addProvider((java.security.Provider)new Provider());
        Security.removeProvider("IBMJCE");
        KeyStore pfx = instance.loadPFX(properties);
        KeyStore jks = instance.loadJKS(properties);
        instance.store(properties, pfx, jks);
    }

    private void showUsage() {
        System.err.println("Usage: import.bat <properties file>");
        System.err.println("Copyright 1999-2010 Client Service International, Inc. All rights reserved.");
        System.exit(0);
    }

    private Properties loadProperties(String file) throws Exception {
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception ex) {
            System.err.println("ERROR: can't load the properties file.");
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
    }

    private KeyStore loadPFX(Properties properties) throws Exception {
        FileInputStream pfxInput = null;
        KeyStore pfx = null;
        String pfxFile = properties.getProperty("jsrcb.pfx.file");
        String pfxPwd = properties.getProperty("jsrcb.pfx.password");
        try {
            pfx = KeyStore.getInstance(KEYSTORE_TYPE_PKCS12, new Provider().getName());
            pfxInput = new FileInputStream(pfxFile);
            pfx.load(pfxInput, "".equals(pfxPwd) ? null : pfxPwd.toCharArray());
            KeyStore keyStore = pfx;
            return keyStore;
        }
        catch (Exception ex) {
            System.err.println("ERROR: can't load the pfx file.");
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (pfxInput != null) {
                try {
                    pfxInput.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
    }

    private KeyStore loadJKS(Properties properties) throws Exception {
        FileInputStream jksInput = null;
        KeyStore jks = null;
        String jksFile = properties.getProperty("jsrcb.jks.file");
        String jksPwd = properties.getProperty("jsrcb.jks.password");
        String keyAlias = properties.getProperty("jsrcb.merchant.key.alias");
        try {
            try {
                jks = KeyStore.getInstance(KEYSTORE_TYPE_JKS);
                jksInput = new FileInputStream(jksFile);
                jks.load(jksInput, "".equals(jksPwd) ? null : jksPwd.toCharArray());
            }
            catch (Exception ex) {
                System.err.println("ERROR: can't load the jks file.");
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (jksInput != null) {
                try {
                    jksInput.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
        if (jks.containsAlias(keyAlias)) {
            System.err.println("ERROR: jks already contains " + keyAlias);
            throw new Exception();
        }
        return jks;
    }

    private void store(Properties properties, KeyStore pfx, KeyStore jks) throws Exception {
        FileOutputStream out = null;
        try {
            try {
                String jksFile = properties.getProperty("jsrcb.jks.file");
                String keyAlias = properties.getProperty("jsrcb.merchant.key.alias");
                String keyPwd = properties.getProperty("jsrcb.merchant.key.password");
                String jksPwd = properties.getProperty("jsrcb.jks.password");
                String pfxPwd = properties.getProperty("jsrcb.pfx.password");
                char[] pfxpwdChar = "".equals(pfxPwd) ? null : pfxPwd.toCharArray();
                char[] jksPwdChar = "".equals(jksPwd) ? null : jksPwd.toCharArray();
                char[] keyPwdChar = "".equals(keyPwd) ? null : keyPwd.toCharArray();
                Enumeration<String> en = pfx.aliases();
                while (en.hasMoreElements()) {
                    String alias = en.nextElement();
                    if (pfx.isCertificateEntry(alias)) {
                        System.out.println("importing certificate " + alias);
                        jks.setCertificateEntry(alias, pfx.getCertificate(alias));
                    }
                    if (!pfx.isKeyEntry(alias)) continue;
                    System.out.println("importing key " + alias + " as " + keyAlias);
                    jks.setKeyEntry(keyAlias, pfx.getKey(alias, pfxpwdChar), keyPwdChar, pfx.getCertificateChain(alias));
                }
                out = new FileOutputStream(jksFile);
                jks.store(out, jksPwdChar);
                System.out.println("success.");
            }
            catch (Exception ex) {
                System.err.println("ERROR: can't import the pfx into jks.");
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
    }
}

