/*
 * Decompiled with CFR 0.152.
 */
package com.jsrcb.payment.client;

import com.jsrcb.payment.client.core.KeyProvider;
import com.jsrcb.payment.client.core.Signature;
import com.jsrcb.payment.client.util.Assert;
import com.sun.net.ssl.internal.ssl.Provider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ResourceBundle;

public class SignatureService {
    private static KeyStore keystore;
    private static ResourceBundle resourceBundle;

    static {
        Security.addProvider((java.security.Provider)new Provider());
        resourceBundle = ResourceBundle.getBundle("jsrcb_merchant");
        String keystoreFilePath = resourceBundle.getString("jsrcb.jks.file");
        String keystorePassword = resourceBundle.getString("jsrcb.jks.password");
        keystore = KeyProvider.getInstance(keystoreFilePath, keystorePassword);
    }

    public static String sign(String plain) {
        Signature signature = new Signature();
        KeyProvider keyProvider = new KeyProvider(keystore);
        String alias = resourceBundle.getString("jsrcb.merchant.key.alias");
        String privatekeyPassword = resourceBundle.getString("jsrcb.merchant.key.password");
        PrivateKey privateKey = keyProvider.getPrivateKey(alias, privatekeyPassword);
        return signature.sign(plain, privateKey);
    }

    public static boolean verify(String plain, String signature) {
        Signature signatureObj = new Signature();
        KeyProvider keyProvider = new KeyProvider(keystore);
        String alias = resourceBundle.getString("jsrcb.paygate.key.alias");
        Certificate certificate = keyProvider.getCertificate(alias);
        Assert.notNull(certificate, "can't get the certificate of paygate.");
        return signatureObj.verify(plain, signature, certificate.getPublicKey());
    }
}

