/*
 * Decompiled with CFR 0.152.
 */
package com.jsrcb.payment.client.core;

import com.jsrcb.payment.client.exception.DataAccessException;
import com.jsrcb.payment.client.util.Assert;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class KeyProvider {
    private static final String DEFAULT_KEYSTORE = "/lib/security/cacerts";
    private static final String JAVA_HOME = "java.home";
    private KeyStore keystore;

    public KeyProvider(KeyStore keystore) {
        this.keystore = keystore;
    }

    public static KeyStore getInstance(String keystoreFilePath, String keystorePassword) {
        if (keystoreFilePath == null) {
            String javahomePath = System.getProperty(JAVA_HOME);
            keystoreFilePath = String.valueOf(javahomePath) + DEFAULT_KEYSTORE;
        }
        char[] pwd = keystorePassword == null ? null : keystorePassword.toCharArray();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(keystoreFilePath));
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, pwd);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            throw new DataAccessException("\u5bc6\u94a5\u5bb9\u5668\u52a0\u8f7d\u5f02\u5e38", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new DataAccessException(e);
                }
            }
        }
    }

    public Certificate getCertificate(String alias) throws DataAccessException {
        Assert.notNull(this.keystore, "keystore is null.");
        Assert.notNull(alias, "certificate alias is null.");
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException ex) {
            throw new DataAccessException(ex);
        }
    }

    public Certificate[] getCertificateChain(String alias) throws DataAccessException {
        Assert.notNull(this.keystore, "keystore is null.");
        Assert.notNull(alias, "certificate chain alias is null.");
        try {
            return this.keystore.getCertificateChain(alias);
        }
        catch (KeyStoreException ex) {
            throw new DataAccessException(ex);
        }
    }

    public PrivateKey getPrivateKey(String alias, String privatekeyPassword) throws DataAccessException {
        Assert.notNull(this.keystore, "keystore is null.");
        Assert.notNull(alias, "private key alias is null.");
        try {
            return (PrivateKey)this.keystore.getKey(alias, privatekeyPassword == null ? null : privatekeyPassword.toCharArray());
        }
        catch (Exception ex) {
            throw new DataAccessException(ex);
        }
    }
}

