/*
 * Decompiled with CFR 0.152.
 */
package com.jsrcb.payment.client.core;

import com.jsrcb.payment.client.exception.SignException;
import com.jsrcb.payment.client.exception.VerifyException;
import com.jsrcb.payment.client.util.Assert;
import java.security.PrivateKey;
import java.security.PublicKey;

public class Signature {
    private static final String MD5WITHRSA_ALGORITHM = "MD5withRSA";

    private String byteToHex(byte[] byteArray) {
        if (byteArray == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            String hexString = Integer.toHexString(byteArray[i] & 0xFF);
            if (hexString.length() != 2) {
                sb.append("0");
            }
            sb.append(hexString);
            ++i;
        }
        return sb.toString();
    }

    private byte[] hexToByte(String hexString) {
        if (hexString == null || hexString.trim().length() == 0) {
            return new byte[0];
        }
        int unit = hexString.length() / 2;
        byte[] byteArray = new byte[unit];
        int i = 0;
        while (i < hexString.length() / 2) {
            String hexChar = hexString.substring(i * 2, i * 2 + 2);
            byteArray[i] = (byte)Integer.parseInt(hexChar, 16);
            ++i;
        }
        return byteArray;
    }

    public String sign(String plain, String algorithm, PrivateKey privateKey) throws SignException {
        Assert.notNull(plain, "plain is null.");
        Assert.notNull(algorithm, "algorithm is null.");
        Assert.notNull(privateKey, "private key is null.");
        try {
            java.security.Signature sign = java.security.Signature.getInstance(algorithm);
            sign.initSign(privateKey);
            sign.update(plain.getBytes());
            return this.byteToHex(sign.sign());
        }
        catch (Exception ex) {
            throw new SignException(ex);
        }
    }

    public String sign(String plain, PrivateKey privateKey) throws SignException {
        return this.sign(plain, MD5WITHRSA_ALGORITHM, privateKey);
    }

    public boolean verify(String plain, String signature, String algorithm, PublicKey publicKey) throws VerifyException {
        Assert.notNull(plain, " plain is null.");
        Assert.notNull(signature, "signature is null.");
        Assert.notNull(algorithm, "algorithm is null.");
        Assert.notNull(publicKey, "public key is null.");
        try {
            java.security.Signature sign = java.security.Signature.getInstance(algorithm);
            sign.initVerify(publicKey);
            sign.update(plain.getBytes());
            byte[] signatureByteArray = this.hexToByte(signature);
            return sign.verify(signatureByteArray);
        }
        catch (Exception ex) {
            throw new VerifyException(ex);
        }
    }

    public boolean verify(String plain, String signature, PublicKey publicKey) throws VerifyException {
        return this.verify(plain, signature, MD5WITHRSA_ALGORITHM, publicKey);
    }
}

