/*
 * Decompiled with CFR 0.152.
 */
package com.xxelin.whale.starter.configuration;

import com.xxelin.whale.config.GlobalConfig;
import com.xxelin.whale.processor.CachedBeanProcessor;
import com.xxelin.whale.starter.properties.WhaleProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={WhaleProperties.class})
@ConditionalOnProperty(prefix="whale", havingValue="true", name={"enable"})
public class WhaleConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CachedBeanProcessor.class})
    public static CachedBeanProcessor cacheBeanProcessor(WhaleProperties whaleProperties, Environment environment) {
        String nameSpace;
        String string = nameSpace = StringUtils.isNotEmpty((CharSequence)whaleProperties.getNamespace()) ? whaleProperties.getNamespace() : environment.getProperty("spring.application.name");
        if (StringUtils.isEmpty((CharSequence)nameSpace)) {
            throw new IllegalStateException("namespace must specified!");
        }
        GlobalConfig configuration = GlobalConfig.builder().namespace(nameSpace).expireSeconds(whaleProperties.getExpireSeconds()).maxSizeLimit(whaleProperties.getMaxSizeLimit()).cacheNull(whaleProperties.isCacheNull()).consistency(whaleProperties.isConsistency()).build();
        return new CachedBeanProcessor(configuration);
    }
}

