package com.youqian.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * Created by hong
 * time 2020/3/31.
 */
@Data
public class PageDto<T extends Serializable> implements Serializable  {

    private static final long serialVersionUID = -8232521877212346922L;

    /** 分页数据 */
    private List<T> list = Collections.emptyList();

    /** 当前页码 */
    private int pageNo=1;

    /** 分页大小 */
    private int pageSize=10;

    /** 总页数 */
    private int totalPages=1;

    /** 总记录数 */
    private int totalSize=0;

    /**
     * 是否有下一页
     */
    private Boolean hasNext=false;

    public static <T extends Serializable> PageDto<T> create(List<T> list, int pageNo, int pageSize, int totalSize) {
        PageDto<T> pageDto = new PageDto<>();
        pageDto.setList(list);
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalSize(totalSize);
        pageDto.setHasNext(list.size() > pageSize);
        int totalPage = (totalSize % pageSize == 0) ? totalSize / pageSize : (totalSize / pageSize + 1);
        pageDto.setTotalPages(totalPage);
        return pageDto;
    }
}
