package com.youqian.api.dto.accesslog;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 访客用户
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
public class AccessLogDto implements Serializable {
    private static final long serialVersionUID = 15856513456986709L;

    /**
     * 累计来访次数
     */
    private Long count;

    /**
     * 相隔时间
     */
    private String time;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 日志的ID
     * not null default = null
     */
    private Long accessLogId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 用户头像
     * max length = 100
     */
    private String avatarUrl;

    /**
     * 访客昵称
     * max length = 60
     */
    private String userName;

    /**
     * 访客手机号
     * max length = 20
     */
    private String mobile;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 商户名称
     * max length = 60
     */
    private String merchantName;

    /**
     * 停留时长(秒)
     * max length = 20
     */
    private String stayTime;

    /**
     * 分享名片的用户ID
     */
    private Long fromUserId;

    /**
     * 渠道
     * max length = 20
     */
    private String channel;

    private Byte readStatus;
    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}