package com.youqian.api.remoteservice;

import com.youqian.api.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.AddStoreRequest;
import com.youqian.api.request.PicRequest;
import com.youqian.api.request.StoreRequest;
import com.youqian.api.response.PicResponse;
import com.youqian.api.response.StoreResponse;

/**
 * @author chenhang
 * @date 2020/3/28
 * @description
 */
@AdvancedFeignClient
public interface RemoteMerchantStoreService {

    /**
     * 获取userId获取店铺信息
     *
     * @param storeRequest merchantId
     * @return PlatformUser
     * @throws BizException
     */
    StoreResponse getStoreInfo(StoreRequest storeRequest) throws BizException;

    /**
     * 店铺的商品图片
     * @param picRequest
     * @return
     * @throws BizException
     */
    PicResponse getStorePic(PicRequest picRequest) throws BizException;

    /**
     * 添加商品信息
     * @param addStoreRequest 商品信息添加
     * @throws BizException
     */
    void add(AddStoreRequest addStoreRequest) throws BizException;

    /**
     * 更新商品信息
     * @param addStoreRequest 商品信息添加
     * @throws BizException
     */
    void update(AddStoreRequest addStoreRequest) throws BizException;

}
