package com.youqian.api.remoteservice;

import com.youqian.api.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.youqian.api.request.TokenVRequest;
import com.youqian.api.request.UserInfoRequest;
import com.youqian.api.response.PlatformUserResponse;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 根据openId获取用户信息
     *
     * @param tokenRequest openId&type
     * @return PlatformUser
     * @throws BizException 用户不存在
     */
    PlatformUserResponse getUserByOpenId(TokenVRequest tokenRequest) throws BizException;

    /**
     * 定时任务处理accessLog的停留时间
     * @throws BizException
     */
    void accessLogJob() throws BizException;

}
