package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class OrderPageResult implements Serializable {

    @ApiModelProperty("订单ID")
    private Long id;

    @ApiModelProperty("头像")
    private String avatarUrl;

    @ApiModelProperty("卖家名称")
    private String name;

    @ApiModelProperty("卖家手机号")
    private String mobilePhone;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("订单状态")
    private Byte orderStatus;

    @ApiModelProperty("订单状态文字")
    private String orderStatusText;

    @ApiModelProperty("运费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal transportFee;

    /*@ApiModelProperty("税费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal tax;*/

    @ApiModelProperty("总应收款")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    @ApiModelProperty("待收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal toCheckBillPrice;

    @ApiModelProperty("货品列表")
    private List<OrderItemResult> skuList;

    /**
     * 订单确认时间
     */
    private Date confirmTime;

    /**
     * 发货时间（操作发票时间）
     */
    private Date deliveryTime;
}
