package com.youqian.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class OrderMainDto implements Serializable {
    private static final long serialVersionUID = 15857374892833494L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 订单ID
     * not null default = 0
     */
    private Long orderId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 订单创建人
     * not null default = 0
     */
    private Long createUserId;

    /**
     * 开单人姓名
     * max length = 64
     * not null default = 
     */
    private String createUserName;

    /**
     * 开单人账号
     * max length = 64
     * not null default = 
     */
    private String createAccount;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 客户UserId
     * not null default = 0
     */
    private Long customerUserId;

    /**
     * 客户手机号
     * max length = 20
     * not null default = 
     */
    private String customerMobile;

    /**
     * 客户经办人名称
     * max length = 20
     * not null default = 
     */
    private String customerName;

    /**
     * 客户企业名称
     * max length = 20
     * not null default = 
     */
    private String customerEnterpriseName;

    /**
     * 商品总额
     * not null default = 0.00
     */
    private BigDecimal goodsPrice;

    /**
     * （原价）订单总额=商品总额+运费+税费等等
     * not null default = 0.00
     */
    private BigDecimal originOrderPrice;

    /**
     * 订单总额折后价
     * not null default = 0.00
     */
    private BigDecimal orderPrice;

    /**
     * 订单优惠价格（优惠了多少价格）
     * not null default = 0.00
     */
    private BigDecimal reducePrice;

    /**
     * 已收款金额
     */
    private BigDecimal receivePrice;

    /**
     * 待收款金额
     * not null default = 0.00
     */
    private BigDecimal restPrice;

    /**
     * 订单状态,0-草稿，1-待确认，2-待发货，3-待收款，4-已完成
     * not null default = 0
     */
    private Byte orderStatus;

    /**
     * 发货状态，0-未发货，1-已发货
     * not null default = 0
     */
    private Byte deliverGoods;

    /**
     * 收款状态，0-未收款，1-收款完成
     * not null default = 0
     */
    private Byte moneyReceiveType;

    /**
     * 订单确认时间
     */
    private Date confirmTime;

    /**
     * 发货时间（操作发票时间）
     */
    private Date deliveryTime;

    /**
     * 订单附属信息，存放定金尾款等不需要检索的订单附属数据
     * max length = 5000
     * not null default = 
     */
    private String orderExt;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}