package com.youqian.api.enums;

import lombok.Getter;

/**
 * @author xiachenhang
 */
@Getter
public enum ActionEnum {
    FOLLOW((byte)1,"follow","关注了"),
    COLLECTION((byte)2,"collection","收藏了"),
    ENQUIRY((byte)3,"enquiry","询价了"),
    COME_IN_STORE((byte)4,"comeIn","访问了"),
    COME_IN_STORE_PHOTO((byte)5,"comeIn","访问了"),
    COME_IN_LIVE_ROOM((byte)6,"comeLiveRoom","进入了"),
    RESERVE_LIVE_ROOM((byte)7,"reserveLiveRoom","订阅了");

    private byte code;
    private String data;
    private String type;

    ActionEnum(byte code,String data, String type){
        this.data = data;
        this.code = code;
        this.type = type;
    }

    public static ActionEnum get(Byte code){
        if(code == null){
            return null;
        }
        for(ActionEnum action:values()){
            if(action.getCode() == code){
                return action;
            }
        }
        return null;
    }

}
