package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/4/8
 * @description
 */
@Getter
public enum EnumPayWay {

    UNKNOWN((byte) 0, "未知"),
    CARD((byte) 1, "银行卡"),
    ALIPAY((byte) 2, "支付宝"),
    WXPAY((byte) 3, "微信"),
    CASH((byte) 4, "现金"),
    OTHERS((byte) 5, "其他"),
    ;

    EnumPayWay(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private byte code;
    private String msg;

    public static EnumPayWay getByCode(Byte code) {
        for (EnumPayWay e : EnumPayWay.values()) {
            if (Objects.equals(e.getCode(), code)) {
                return e;
            }
        }

        return UNKNOWN;
    }
}
