package com.youqian.api.params;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by hong
 * time 2020/3/31.
 */
@Data
public class PageParam implements Serializable {
    private static final long serialVersionUID = -4153795017300339000L;

    /**
     * 页码
     */
    private Integer pageNo = 1;

    /**
     * 页数
     */
    private Integer pageSize = 20;

    /**
     * 不需传入，仅用于计算分页偏移量
     */
    @Deprecated
    private Integer offset;

    public Integer getOffset() {
        if(Objects.nonNull(offset)){
            return offset;
        }
        if(Objects.nonNull(pageNo) && Objects.nonNull(pageSize)){
            return (pageNo-1)*pageSize;
        }
        return null;
    }
}
