package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/4/2
 * @description
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class CreateOrderRequest extends Operator implements Serializable {

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "客户ID", required = true)
    private Long customerId;

    @Valid
    @Size(min = 1)
    @NotNull
    @ApiModelProperty(value = "商品详情", required = true)
    private List<GoodsRequest> goodsList;

    @ApiModelProperty(value = "运费")
    private BigDecimal transportFee;

    @NotNull
    @ApiModelProperty(value = "运输方式， 1-卖家送货/2-买家自提", required = true)
    private Byte transType;

    @ApiModelProperty(value = "交货地址（买家自提情况下必填）")
    private String deliveryAddress;

    @ApiModelProperty(value = "商品最终价格")
    private BigDecimal orderPrice;
}
