package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author tengtuox
 * @date 2020/4/20
 * @description
 */
@Data
public class GoodsResult implements Serializable {

    @ApiModelProperty("goodsId")
    private Long goodsId;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("数量")
    private Integer num;

    @ApiModelProperty("总价格")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;
}
