package com.youqian.api.dto.backlog;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 待办事项
 * @author youqian mybatis generator 
 * 2020-09-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BackLogDto implements Serializable {
    private static final long serialVersionUID = 16013486268291369L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 待办事项ID
     * not null default = 0
     */
    private Long backlogId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 员工ID
     * not null default = 0
     */
    private Long employeeId;

    /**
     * 类型
     * max length = 40
     * not null default = 
     */
    private String backlogType;

    /**
     * 作用权限:0-商户维度 1-个人维度
     * not null default = 0
     */
    private Byte roleRange;

    /**
     * 身份:0-管理员，1-员工
     * not null default = 0
     */
    private Byte roleType;

    /**
     * 完成条件 0-未完成  1-完成
     * not null default = 0
     */
    private Byte finishStatus;

    /**
     * 完成类型 0-一次性完成 1-分子分母完成
     * not null default = 0
     */
    private Byte finishType;

    /**
     * 数字分子
     * not null default = 0
     */
    private Integer numMolecular;

    /**
     * 需要完成的数字
     * not null default = 0
     */
    private Integer numFinish;

    /**
     * 删除状态
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}