package com.youqian.api.dto.customer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户的客户表
 * @author youqian mybatis generator 
 * 2020-03-31
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerDto implements Serializable {
    private static final long serialVersionUID = 15856513457048043L;

    /**
     * 自增键
     * not null default = null
     */
    private Long id;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 员工名
     */
    private String employeeName;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 用户ID
     * not null default = 0
     */
    private Long userId;

    /**
     * 账号，冗余PlatformUser表account字段
     * max length = 100
     * not null default = 
     */
    private String account;

    /**
     * 手机号码，冗余PlatformUser表mobile字段
     * max length = 20
     * not null default = 
     */
    private String mobile;

    /**
     * 客户名称，冗余platformUser表的userName字段
     * max length = 100
     * not null default = 
     */
    private String userName;

    /**
     * 头像，冗余platformUser表的avatar_url字段
     * max length = 100
     * not null default = 
     */
    private String avatarUrl;

    /**
     * 企业名称
     * max length = 64
     * not null default = 
     */
    private String enterpriseName;

    /**
     * 客户标签,标签表ID组，逗号隔开
     * max length = 60
     * not null default = 
     */
    private String tab;

    /**
     * 待收款金额
     * not null default = 0.00
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal restPrice;

    /**
     * 交易总金额
     * not null default = 0.00
     */
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    /**
     * 开单次数
     * not null default = 0
     */
    private Integer createOrderCount;

    /**
     * 最近一次开单时间
     */
    private Date lastCreateOrderTime;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 主体id
     */
    private Long signEntityId;

    /**
     * 是否删除，0-未删除，其他-已删除
     */
    private Byte deleted;

    /**
     * 是否黑名单 1是 0否
     */
    private Byte blacklist;

    /**
     * 黑名单操作员工id
     */
    private Long blacklistOperator;

    /**
     * 黑名单操作时间
     */
    private Date blacklistOperatorTime;

    /**
     * 申请状态  （申请观看直播）3-未处理/2-已同意/1-已拒绝/0未申请
     */
    private Byte applicationStatus;

    /**
     * 申请同意或拒绝操作员工id
     */
    private Long applyOperator;

    /**
     * 申请同意或拒绝操作时间
     */
    private Date applyOperatorTime;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 申请理由
     */
    private String applyReason;

    /**
     * 省
     */
    private String province;

    /**
     * 城市
     */
    private String  city;

    /**
     * 最后互动时间
     */
    private Date    recentInteractionTime;

    /**
     * 总互动次数
     */
    private Integer interactionsTotal;

    /**
     * 0访客 1一般客户 2重要客户 3核心客户 冗余customer_label表
     */
    private Integer customerLevel;

    /**
     * 公司id
     */
    private Long    companyId;

    /**
     * 互动分
     */
    private Integer interactionsScore;

    /**
     * 性别 0未知  1男  2女
     */
    private Byte    gender;

    /**
     * 客户来源
     */
    private String  customerSource;

    /**
     * 来源类型
     */
    private Integer sourceType;

    /**
     * 首次互动时间
     */
    private Date firstInteractionTime;

}