package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 页面与组件关联表
 * @author youqian mybatis generator 
 * 2020-09-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageComponentRDto implements Serializable {
    private static final long serialVersionUID = 16011959762465738L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageComponentRId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 组件id
     * not null default = 0
     */
    private Long componentId;

    /**
     * 页面id
     * not null default = null
     */
    private Long pageId;
}