package com.youqian.api.dto.page;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 页面表
 * @author youqian mybatis generator 
 * 2020-09-29
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PageDto implements Serializable {
    private static final long serialVersionUID = 16013474547157360L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long pageId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleted;

    /**
     * 对应页面路由
     * max length = 255
     * not null default = null
     */
    private String pageRoute;

    /**
     * 页面名
     * max length = 30
     * not null default = null
     */
    private String pageName;

    /**
     * 是否支持组件化
     * not null default = 0
     */
    private Byte supportComponents;

    /**
     * 组件别名
     * max length = 100
     * not null default = null
     */
    private String pageAlias;
}