package com.youqian.api.dto.shopgoods.custom;

import com.youqian.api.dto.shopgoods.ShopGoodsDto;
import com.youqian.api.dto.shopgoods.ShopGoodsSkuDto;
import com.youqian.api.dto.shopgoods.ShopGoodsTagDto;
import com.youqian.api.dto.shopgoods.custom.picture.GoodsInfoPicDto;
import com.youqian.api.dto.shopgoods.custom.spec.ColorAndSizeSpecDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商品各类信息集合dto(新版)
 * Created by hong
 * time 2020/6/28.
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class GoodsWholeInfoV1 extends ShopGoodsDto {

    private static final long                  serialVersionUID = -8474977647014491495L;
    /**
     * 商品图片集合
     */
    private List<GoodsInfoPicDto> shopGoodsPictureDtos;

    /**
     * 商品规格集合
     */
    private List<ColorAndSizeSpecDto> colorAndSizeSpecDtos;

    /**
     * 商品标签集合
     */
    private List<ShopGoodsTagDto> shopGoodsTagDtos;

    /**
     * 规格集合
     */
    List<SkuDto>              skus;

    /**
     * 是否收藏
     */
    private Boolean collect;
    /**
     * 是否询价
     */
    private Boolean enquiry;

    /**
     * 商户名称
     */
    private String merchantName;
}
