package com.youqian.api.dto.wms;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 商品出入库单
 * @author youqian mybatis generator 
 * 2020-10-26
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WmsOrderDto implements Serializable {
    private static final long serialVersionUID = 16037007112421878L;

    /**
     * 自动增长编号
     * not null default = null
     */
    private Long id;

    /**
     * 商品入库单编号
     * not null default = 0
     */
    private Long wmsOrderId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 删除表示 0-正常 1-删除
     * not null default = null
     */
    private Boolean deleted;

    /**
     * 出入库盘点单号
 1-入库 2-预定库存 4-取消预订 8-出库 16-盘点
     * not null default = 0
     */
    private Boolean orderType;

    /**
     * 入库单号
     * not null default = null
     */
    private Long orderNo;

    /**
     * 操作人编号
     * not null default = 0
     */
    private Long employeeId;
}