package com.youqian.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum BaiDuLicenseParamEnum {
    regCode("regCode","社会信用代码"),
    regCode_1("regCode","证件编号"),
    name("name","单位名称"),
    legalPerson("legalPerson","法人"),
    establishDate("establishDate","成立日期"),
    registeredAssets("registeredAssets","注册资本"),
    type_1("type","组成形式"),
    address("address","地址");

    private String code;
    private String type;

    public static Map params;

    static {
        params = new HashMap<>();
        for(BaiDuLicenseParamEnum param:values()){
            params.put(param.getType(),param.getCode());
        }
    }

    BaiDuLicenseParamEnum(String code,String type){
        this.code = code;
        this.type = type;
    }
}
