package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/1/6
 * @description
 */
@Getter
public enum EnumAddressType {

    /**
     * 地址类型
     */
    SEND((byte) 1, "发货地址"),
    GET((byte) 2, "提货地址"),
    ;

    private final byte code;

    private final String desc;

    EnumAddressType(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isSend(Byte code) {
        return Objects.equals(SEND.code, code);
    }

    public static boolean isGet(Byte code) {
        return Objects.equals(GET.code, code);
    }

}
