package com.youqian.api.enums.customer;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2020/3/31.
 */
@Getter
public enum SortPropertyEnum {
    CREATE_TIME(0,"createTime",",添加时间优先"),
    AMOUNT_COLLECTED(1,"amountCollected","按待收金额排序"),
    SINGLE(2,"single","按单量排序"),
    TRANSACTION_AMOUNT(3,"transactionAmount","按交易金额排序"),
    BILLING_TIME(4,"billingTime","按开单时间排序"),
    ABC(5, "abc", "按拼音首字母排序")
    ;

    private final Integer code;

    private final String type;

    private final String desc;

    SortPropertyEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static SortPropertyEnum getByCode(Integer code) {
        return Stream.of(SortPropertyEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(CREATE_TIME);
    }

    public static SortPropertyEnum getByType(String type) {
        return Stream.of(SortPropertyEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(CREATE_TIME);
    }

    public static SortPropertyEnum getByDesc(String desc) {
        return Stream.of(SortPropertyEnum.values()).filter(e -> e.getDesc().equals(desc)).findFirst().orElse(CREATE_TIME);
    }
}

